function [ ] = LURNZ_Greenhouse_Gas_Module(pixel_size, output_path, last_year, GHGM_PDFS, GHGM_ASCI, ALL_YEARS )
%
% Module 3 of LURNZ
% the land use intensity module spatially calculates the intensity of land
% use. For dairy farming this is milk solds per hectare. For sheep/beef
% farming this is stock units per hectare. Fertiliser is not considered.
%

% Land Use Intensity Module (LUIM)
% Code by Simon Anastasiadis : 2012-01-13

%% Inform User Module Beginning

msg = sprintf(' - Greenhouse Gas Module initialized');
disp(msg)

%% Load data

[dairyMS, SheepSR, ForestAge, ScrubAge, LURNZDATA, c, GISheader, coef, lookup_tables] = GHGM1_load_data(output_path, ALL_YEARS);

%% Run analysis

[EMISSIONS, EMISSION_SOURCE] = GHGM2_greenhouse_gas_calculation(dairyMS, SheepSR, ForestAge, ScrubAge, LURNZDATA, c, coef, last_year, lookup_tables, ALL_YEARS );

%% Save output

GHGM3_save_results(EMISSIONS, EMISSION_SOURCE, LURNZDATA, c, GISheader, pixel_size, output_path, last_year, GHGM_PDFS, GHGM_ASCI, ALL_YEARS );

%% Inform User Module Complete

msg = sprintf(' - Greenhouse Gas Module complete');
disp(msg)

end

